#!/usr/bin/env bash
#
#SBATCH --partition=gypsum-1080ti
#SBATCH --gres=gpu:1
#SBATCH --time=03-00:00:00
#SBATCH --mem=16000
#SBATCH --output=outputs/output_%j.out
#SBATCH --cpus-per-task=8

seed_gru=${1:-0}
seed_sac=${2:-0}
env_name=${3:-InvertedPendulum-v2}
steps=${4:-2}
train_steps=${5:-30}


echo $seed $env_name $steps

python record_videos.py --seed_gru $seed_gru --seed_sac $seed_sac --env_name $env_name --steps $steps --train_steps $train_steps
exit